#!/bin/sh

# Si l'utilisateur est bien root
if [ "$(id -u)" -ne 0 ]
then
	echo "You must be root"
	exit 1
fi

# Variables
DISTRIB_CODENAME="$(lsb_release -cs)"
ROOT_DIR="$(dirname "$(readlink -f "$0")")"
DATA_DIR="${ROOT_DIR}/.data"
ZENITY_TITLE="Nvidia Installer"
LOGFILE=/tmp/nvidia-install.log

# Supression d'un log précédent
rm -f "$LOGFILE"

lspci 2> /dev/null | grep VGA | grep -i nvidia >> "$LOGFILE" 2>&1
if [ $? -ne 0 ]
then
	zenity --error --title="$ZENITY_TITLE" --text="Your system doesn't have a Nvidia graphic card.\n\nInstallation aborded."
	exit 1
fi

zenity --question --title="$ZENITY_TITLE" --text="The Nvidia Graphic Driver will be installed.\n\nThis will restart your computer\nAre you sure to proceed ?"
if [ $? -eq 1 ]
then
    exit 2
fi

# Wrapper pour zenity
{
	# Ajout des dépots Debian
	echo "# Adding Debian repository"
	echo "deb http://ftp.debian.org/debian/ $DISTRIB_CODENAME main contrib non-free" > /etc/apt/sources.list.d/caldera-extra-tools.list 2> "$LOGFILE"
	echo "10"

	# Mise à jour du cache d'apt
	echo "# Updating apt-get cache"
	DEBIAN_FRONTEND=noninteractive apt-get --quiet --assume-yes --allow-unauthenticated update                 >> "$LOGFILE" 2>&1
	echo "30"

	# Installation manuelle des dépendances 32bits du .deb via apt-get
	echo "# Installing package"
	DEBIAN_FRONTEND=noninteractive apt-get --quiet --assume-yes --allow-unauthenticated install nvidia-driver nvidia-opencl-icd  >> "$LOGFILE" 2>&1
	APT_RES=$?
	echo "50"

	# Si apt s'est bien déroulé
	if [ "$APT_RES" -eq 0 ]
	then
		# Copie des fichiers de Nvidia
		echo "# Disabling nouveau driver..."

		echo "blacklist nouveau" > /etc/modprobe.d/blacklist-nvidia-nouveau.conf
		echo "options nouveau modeset=0" >> /etc/modprobe.d/blacklist-nvidia-nouveau.conf

		update-initramfs -u

		echo "100"

		sleep 1

		systemctl reboot

	else
		zenity --error --title="$ZENITY_TITLE" --text="An error occured during installation : $LOGFILE"
		exit 1
	fi
} | zenity --progress --percentage=0 --title="$ZENITY_TITLE" --text="Installing..." --auto-close --no-cancel

