#!/bin/sh

# Si l'utilisateur est bien root
if [ "$(id -u)" -ne 0 ]
then
	echo "You must be root"
	exit 1
fi


# ----------------------------
#  Installation de Nvidia Driver
#

ROOT_DIR="$(dirname "$(readlink -f "$0")")"
DATA_DIR="${ROOT_DIR}/.data"
ZENITY_TITLE="Autofs-Samba-Debian10"
LOGFILE=/tmp/smbautofs-install.log

# Supression d'un log précédent
rm -f "$LOGFILE"


# Wrapper pour zenity
{
	# Ajout des dépots Debian

	# Mise à jour du cache d'apt
	echo "# Updating apt-get cache"
	DEBIAN_FRONTEND=noninteractive apt-get --quiet --assume-yes --allow-unauthenticated update                 >> "$LOGFILE" 2>&1
	echo "30"

	# Installation manuelle des dépendances 32bits du .deb via apt-get
	echo "# Installing package"
	DEBIAN_FRONTEND=noninteractive apt-get --quiet --assume-yes --allow-unauthenticated install autofs smbclient cifs-utils samba nfs-common  >> "$LOGFILE" 2>&1
	APT_RES=$?
	echo "80"

	# Si apt s'est bien déroulé
	if [ "$APT_RES" -eq 0 ]
	then
		# Copie des fichiers de Nvidia
		echo "# Installing files"
		
		tar -C /etc -xpf "$DATA_DIR"/autofs.tar.gz >> "$LOGFILE" 2>&1
		cp "$DATA_DIR"/smb.conf /etc/samba/smb.conf >> "$LOGFILE" 2>&1
		echo "100"

		 /usr/bin/systemctl restart smbd >> "$LOGFILE" 2>&1
		 /usr/bin/systemctl restart autofs >> "$LOGFILE" 2>&1
	else
		zenity --error --title="$ZENITY_TITLE" --text="An error occured during installation : $LOGFILE"
		exit 1
	fi
} | zenity --progress --percentage=0 --title="$ZENITY_TITLE" --text="Installing..." --auto-close --no-cancel

zenity --info --title="$ZENITY_TITLE" --text="Installation Done"