#!/bin/sh

# Si ce n'est pas un Linux
if [ "$(uname)" != "Linux" ]
then
	echo "This is for Linux only"
	exit 1
fi

# Variables
ROOT_DIR="$(dirname "$(readlink -f "$0")")"
DISTRIB_ID="$(lsb_release -is)"
DISTRIB_CODENAME="$(lsb_release -cs)"

# Si c'est une Debian Jessie ou Stretch
if [ "$DISTRIB_CODENAME" = "jessie" ] || [ "$DISTRIB_CODENAME" = "stretch" ]
then
	# Lance l'installation
	pkexec env DISPLAY="$DISPLAY" XAUTHORITY="$XAUTHORITY" DISTRIB_CODENAME="$(lsb_release -cs)" sh "$ROOT_DIR"/.install_as_root.sh
else
	# Si ce n'est pas une Jessie/Stretch
	echo "This computer is not a Jessie or Stretch"
	exit 1
fi


